str(cars)

plot(cars, main = "Distância de parada versus Velocidade", 
    xlab = "Velocidade (mph)", ylab = "Distância (ft)", xlim=c(0,25), pch=20, lwd=.3)

##Construindo as Matrizes
X <- cbind(b0=1, b1=cars$speed)
y <- cbind(cars$dist)

##Calculando os Betas matricialmente (X'X)^-1 * X'y
XX <- t(X) %*% X
XXi <- solve(XX)
betas <- XXi %*% t(X) %*% y; betas

lm(dist~speed, data=cars)

xl <- 0:25
yl <- betas[1] + betas[2]*xl
lines(xl,yl,col=2)

##Ajustando um polinômio de segundo grau
X <- cbind(b0=1, b1=cars$speed, b2=cars$speed^2)
XX <- t(X) %*% X
XXi <- solve(XX)
betas <- XXi %*% t(X) %*% y; betas

lm(dist~speed+I(speed^2), data=cars)

yl <- betas[1] + betas[2]*xl + betas[3]*xl^2
lines(xl,yl,col=4)

## Quadro de anova.
H <- X%*%XXi%*%t(X)

n <- nrow(X)
p <- sum(diag(H))

I <- diag(nrow(X))
J <- 1+0*I

an <- data.frame(
  fv=c("Reg(b2,b1)","Res","Tot"),
  gl=c(p-1, n-p, n-1),
  sq=c(
    t(y) %*% (H-J/n) %*% y,
    t(y) %*% (I-H) %*% y,
    t(y) %*% (I-J/n) %*% y))
an <- transform(an, qm=sq/gl)
an <- transform(an, f=qm/rev(qm)[2])
an <- transform(an, p=pf(f, df1=gl, df2=rev(gl)[2], lower=FALSE))
an

anova(lm(y~X))
