### R code from vignette source 'aRTgpm.Rnw'

###################################################
### code chunk number 1: "Rsettings"
###################################################
options(width=69)


###################################################
### code chunk number 2: "Loading package"
###################################################
require(aRT) 
con=openConn(name="default")


###################################################
### code chunk number 3: "Importing data"
###################################################
db=createDb(con, "gpm", replace=TRUE)

llotes = createLayer(db, "lotes")
lcomunidades = createLayer(db, "comunidades")
lrodovias = createLayer(db, "rodovias")

comufn = system.file("shapes/comunidades_UTM.shp", package="aRT")
rodofn = system.file("shapes/rodovias_UTM.shp", package="aRT")
lotefn = system.file("shapes/lotes_UTM.shp", package="aRT")

addShape(lcomunidades, tab="comus", file=comufn, ID="objeid_37")
addShape(lrodovias, tab="rodos", file=rodofn,       ID="objeid_57")
addShape(llotes, tab="lotes", file=lotefn,       ID="id")

rm(db)
invisible(gc())


###################################################
### code chunk number 4: "Opening database"
###################################################
db=openDb(con, "gpm")

llotes = openLayer(db, "lotes")
lcomunidades = openLayer(db, "comunidades")
lrodovias = openLayer(db, "rodovias")

rodovias    = getLines(lrodovias)
comunidades = getPoints(lcomunidades)
lotes       = getPolygons(llotes)


###################################################
### code chunk number 5: aRTgpm.Rnw:101-106
###################################################
par(mar=c(.5,.5,.5,.5))

plot(llotes, col="dark green")
plot(lrodovias, add=T, col="red", lwd=2)
plot(lcomunidades, pch=22, add=T, bg = "blue", col="blue")


###################################################
### code chunk number 6: "Importing data"
###################################################
lcells = createLayer(llotes, "cells", 150) ## ORIGINAL IS 150
cells  = getCells(lcells, slice=3000) # le de 3000 em 3000, fica bem mais rapido
centroids = getOperation(llotes, operation="centroid")


###################################################
### code chunk number 7: aRTgpm.Rnw:124-129
###################################################
par(mar=c(.5,.5,.5,.5))

plot(llotes, lty=0, col="dark green")
plot(lcells, add=T)
plot(centroids, pch=23, bg="yellow",add=T)


###################################################
### code chunk number 8: "GPM cell lotes"
###################################################
mytable = connectToBiggerIntersectionArea(cells, llotes)

get_property_from_cell = function(id)
{
    list(ids=mytable[id,"father"], area = mytable[id,"area"])
}


###################################################
### code chunk number 9: "Silent"
###################################################
aRTsilent(TRUE)


###################################################
### code chunk number 10: "GPM cell lotes"
###################################################
gpmcellsprop = createGPM(lcells, get_property_from_cell)
as.data.frame(gpmcellsprop[1:2])


###################################################
### code chunk number 11: "Silent"
###################################################
aRTsilent(FALSE)


###################################################
### code chunk number 12: "Save GPM"
###################################################
saveGPM(gpmcellsprop, "cell-neighborhood.gpm", "cells", "lotes")


###################################################
### code chunk number 13: aRTgpm.Rnw:183-192
###################################################
fat= as.numeric(mytable[,"father"])
colors_lotes = sample(rainbow(3239))
real_colors = colors_lotes[fat]
real_colors[which(is.na(real_colors))]= "white"
par(mar=c(.5,.5,.5,.5))

plot(cells, col=real_colors)
plot(lotes, add=T)
box()


###################################################
### code chunk number 14: "Silent"
###################################################
aRTsilent(TRUE)


###################################################
### code chunk number 15: "GPM cell lotes"
###################################################
get_neighbors_lotes   = getNeighborsMaxDistanceFunction(centroids, 1000)
gpmdistance  = createGPM(llotes, get_neighbors_lotes)


###################################################
### code chunk number 16: "Silent"
###################################################
aRTsilent(FALSE)


###################################################
### code chunk number 17: aRTgpm.Rnw:222-252
###################################################
plot_neighborhood_lines = function(points, neighborhood)
{
    id_points = getID(points)

    for(i in 1:length(id_points))
    {
        p1 = points@coords[i,]

        neighbors = neighborhood[[id_points[i]]]$ids

        for(j in 1:length(neighbors))
        {
            mywhich = which(neighbors[j] == id_points)
            if(length(mywhich) > 0)
            {
                p2 = points@coords[mywhich,]
                lines(c(p1[1],p2[1]), c(p1[2],p2[2]), lty=2)
            }
        }
    }
}

colors_lotes = sample(rainbow(length(getID(centroids))))
par(mar=c(.5,.5,.5,.5))

plot(lotes, col=colors_lotes)
plot_neighborhood_lines(centroids, gpmdistance)
plot(centroids, pch=".", cex=3, add=T)
plot(centroids, pch=".", cex=2, add=T, col=colors_lotes)
box()


###################################################
### code chunk number 18: "Silent"
###################################################
aRTsilent(TRUE)


###################################################
### code chunk number 19: "GPM intersection lines"
###################################################
get_neighbor_lines = getNeighborsIntersectionLines(lcells, lrodovias)
gpm_intersection_lines = createGPM(lcells, get_neighbor_lines)


###################################################
### code chunk number 20: "Silent"
###################################################
aRTsilent(FALSE)


###################################################
### code chunk number 21: "Silent"
###################################################
aRTsilent(TRUE)


###################################################
### code chunk number 22: "GPM contained points"
###################################################
get_neighbor_points = getNeighborsContainedPoints(lcells, lcomunidades)
gpm_contained_points = createGPM(lcells, get_neighbor_points)


###################################################
### code chunk number 23: "Silent"
###################################################
aRTsilent(FALSE)


###################################################
### code chunk number 24: "Silent"
###################################################
aRTsilent(TRUE)


###################################################
### code chunk number 25: "GPM intersection between lines and polygons"
###################################################
get_neighbor_lines_pols = connectLineToIntersectionPolygons(lrodovias, llotes)
gpmLinePols = createGPM(lrodovias, get_neighbor_lines_pols)


###################################################
### code chunk number 26: "Silent"
###################################################
aRTsilent(FALSE)


###################################################
### code chunk number 27: "Silent"
###################################################
aRTsilent(TRUE)


###################################################
### code chunk number 28: "GPM open network"
###################################################
data = getData(openTable(lrodovias))

network = createOpenNetwork(comunidades, rodovias, function(d, id) {
  pos = which(data[,"OBJEID_57"] == id)
  if(length(pos) == 1 && data[pos, "CD_PAVIMEN"] == "pavimentada")
        return(d/5)
  else  
        return(d/2)
})



###################################################
### code chunk number 29: "Open Network function"
###################################################
get_neighbors_net  = getNeighborsOpenNetworkFunction(centroids, network)
gpmnetwork   = createGPM(llotes, get_neighbors_net)


###################################################
### code chunk number 30: "Silent"
###################################################
aRTsilent(FALSE)


###################################################
### code chunk number 31: aRTgpm.Rnw:384-418
###################################################
plot_neighborhood_points = function(start_points, end_points, end_points_colors, neighborhood, lines, border)
{
    id_end_points       = getID(end_points)
    length_end_points   = length(id_end_points)
    length_start_points = length(getID(start_points))

    plot(end_points)

    for(i in 1:length_start_points)
    {
        mywhich = which(neighborhood[[i]]$ids == id_end_points)
        if(length(mywhich) > 0)
        {
            col = end_points_colors[mywhich]
            plot(lotes[i,], col=col, pch=20, add=T)
        }
    }

    plot(lines, lwd=2, add=T)

    for(i in 1:length_end_points)
    {
        col = end_points_colors[i]
        id = getID(end_points)[i]
        plot(end_points[i,], bg=col, pch=21, cex=3,add=T)
        text(end_points@coords[i,1], end_points@coords[i,2], labels=i)
    }
}

colors_comunidades = c("#FF004DFF", "#00FFB2FF", "#CCFF00FF", "#0066FFFF")
par(mar=c(.5,.5,.5,.5))

plot_neighborhood_points(centroids, comunidades, colors_comunidades, gpmnetwork, rodovias, lotes)
box()


###################################################
### code chunk number 32: "Saving gpmnetwork in a GPM file"
###################################################
saveGPM(gpmnetwork, "gpmnetwork.gpm", "lotes", "comunidades")


###################################################
### code chunk number 33: "Saving gpmdistance in a GAL file"
###################################################
saveGPM(gpmdistance, "gpmdistance.GAL", "lotes")


###################################################
### code chunk number 34: "Saving gpmdistance in a GWT file"
###################################################
saveGPM(gpmdistance, "gpmdistance.GWT", "lotes", attrib="distance")


