### R code from vignette source 'aRTsp.Rnw'

###################################################
### code chunk number 1: "createDb"
###################################################
require(aRT)
aRTsilent(TRUE) # hiding info messages
con = openConn(name="default")
if(any(showDbs(con)=="sp")) deleteDb(con, "sp", force=T)
db = createDb(con, "sp")


###################################################
### code chunk number 2: "aRTconn"
###################################################
vignette("aRTconn", package="aRT")


###################################################
### code chunk number 3: "seed"
###################################################
set.seed(13331)
# library(lattice)


###################################################
### code chunk number 4: "spatialPoints"
###################################################
xy = matrix(runif(20), nc=2)
xy.sp = SpatialPoints(xy)
xy.sp


###################################################
### code chunk number 5: "spatialPointsDataFrame"
###################################################
xy.spdf = SpatialPointsDataFrame(xy, data.frame(ID=paste(1:10)))


###################################################
### code chunk number 6: "createLayerPoints"
###################################################
lpoints = createLayer(db, "points")
lpoints


###################################################
### code chunk number 7: "addLayerPoints"
###################################################
addPoints(lpoints, xy.spdf)
lpoints


###################################################
### code chunk number 8: "createTablePoints"
###################################################
tpoints = createTable(lpoints, "tpoints")
tpoints
lpoints


###################################################
### code chunk number 9: "getLayerPoints"
###################################################
points = getPoints(lpoints)
points


###################################################
### code chunk number 10: aRTsp.Rnw:176-181
###################################################
par(mfrow=c(1,2), mar=c(.5,.5,.5,.5), mgp=c(1.8,.8,0))
plot(points)
box()
plot(lpoints)
box()


###################################################
### code chunk number 11: "addPointsDataFrame"
###################################################
df = data.frame(z1 = round(5 + rnorm(10), 2), z2 = 0:9, ID = paste(1:10))
xy.spdf = SpatialPointsDataFrame(xy.sp, df)
xy.spdf


###################################################
### code chunk number 12: "importPointsTable"
###################################################
lpointsdf = createLayer(db, "lpointsdf")
addPoints(lpointsdf, xy.spdf)
tpointsdf = importTable(lpointsdf, "tpointsdf", ID="ID", xy.spdf)
tpointsdf
lpointsdf


###################################################
### code chunk number 13: "getPointsDataFrame"
###################################################
getPoints(lpointsdf, tpointsdf)


###################################################
### code chunk number 14: "spatialLines"
###################################################
l1 = cbind(c(1,2,3),c(3,2,2))
l1a = cbind(l1[,1]+.05,l1[,2]+.05)
l2 = cbind(c(1,2,3),c(1,1.5,1))
Sl1 = Line(l1)
Sl1a = Line(l1a)
Sl2 = Line(l2)
#S1 = Lines(list(Sl1, Sl1a), ID="a")
S1 = Lines(list(Sl1), ID="a")
S2 = Lines(list(Sl2), ID="b")
S3 = Lines(list(Sl1a), ID="c")
Sl = SpatialLines(list(S1,S2,S3))

llines = createLayer(db,"llines")

addLines(llines, Sl)

createTable(llines, "llines")


###################################################
### code chunk number 15: aRTsp.Rnw:256-261
###################################################
par(mfrow=c(1,2), mar=c(.5,.5,.5,.5), mgp=c(1.8,.8,0))
plot(Sl)
box()
plot(llines)
box()


###################################################
### code chunk number 16: "seedAgain"
###################################################
set.seed(25)


###################################################
### code chunk number 17: "spatialPolygons"
###################################################

#genPol = function(quant)
#{
#    res = list()
#    res = lapply(1:quant, function(x) {
#        from = round(runif(2,1,20),2)
#        to   = from + round(runif(2,1,5),2)
#
#        Sr1 = Polygon(cbind(c(from[1],from[1],to[1],to[1],  from[1]),
#                          c(from[2],to[2],  to[2],from[2],from[2])))
#        Srs1 = Polygons(list(Sr1),paste(x))
#    })
#    SR = SpatialPolygons(res, 1:quant)
#}

Sr1 = Polygon(cbind(c(2,4,4,1,2),c(2,3,5,4,2)))
Sr2 = Polygon(cbind(c(5,4,2,5),c(2,3,2,2)))
Sr3 = Polygon(cbind(c(4,4,5,10,4),c(5,3,2,5,5)))
Sr4 = Polygon(cbind(c(5,6,6,5,5),c(4,4,3,3,4)), hole = TRUE)

Srs1 = Polygons(list(Sr1), "s1")
Srs2 = Polygons(list(Sr2), "s2")
Srs3 = Polygons(list(Sr3, Sr4), "s3/4")
SR = SpatialPolygons(list(Srs1,Srs2,Srs3), 1:3)

lrings = createLayer(db, "lrings")

addPolygons(lrings, SR)

trings = createTable(lrings, "trings")

#th=createTheme(lrings, "trings")
lrings

#sr = as.SpatialPolygon(getGeometry(lrings))

pols = getPolygons(lrings)


###################################################
### code chunk number 18: aRTsp.Rnw:323-328
###################################################
par(mfrow=c(1,2), mar=c(.5,.5,.5,.5), mgp=c(1.8,.8,0))
plot(SR, col=1:3, pbg="white")
box()
plot(pols, col=1:3,pbg="white")
box()


###################################################
### code chunk number 19: "addPolygonsDataFrame"
###################################################
#attr = data.frame(a=1:3, b=3:1, row.names=c("s1","s2","s3/4"))
#SrDf = SpatialPolygonsDataFrame(SR, attr)
#lringsdf = createLayer(db, "lringsdf")
#addPolygons(lringsdf, SrDf)


###################################################
### code chunk number 20: "polygonsDataFrameAtData"
###################################################
#xy.spdf@data
#SrDf@data
#class(SrDf@data)


###################################################
### code chunk number 21: "as.Spatial"
###################################################
#tringsdf = createTable(lringsdf, "tringsdf", ID="ID", gen=F)
#createColumn(tringsdf, "a", "i")
#createColumn(tringsdf, "b", "i")
#addRows(tringsdf, SrDf@data)
#tringsdf
#lringsdf

#getData(tringsdf)

#sr = as.SpatialPolygons(getGeometry(lringsdf))
#summary(sr)
#sr = as.SpatialPolygonsDataFrame(getGeometry(lringsdf))
#sr


