#!/bin/sh

#  aRT : API R - TerraLib                                                
#  Copyright (C) 2003-2010 LEG                                          
#                                                                        
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License as published by  
#  the Free Software Foundation; either version 2 of the License, or     
#  (at your option) any later version.                                   
#                                                                        
#  This program is distributed in the hope that it will be useful,       
#  but WITHOUT ANY WARRANTY; without even the implied warranty of        
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
#  GNU General Public License for more details.                          
#                                                                        
#  You should have received a copy of the GNU Lesser General Public      
#  License along with this library.

# This script runs under Debian/Linux
# Run this script using a superuser
# Last change: 20090806

# Valid arguments:
# --no-qt
# --no-mysql
# --no-terraview
# --no-terralib
# --no-updatedb
# --no-add-system-variables
# --with-r-dev
# --tldir:/my/own/path:

LINE="========================================================\n"
TEMP=/tmp/tmp.$$
CURRENT_DIR=`pwd`

printf $LINE
printf "                aRT : API R - TerraLib\n"
printf "             Copyright (C) 2003-2010  LEG\n"
printf $LINE
printf "\nThis script installs aRT dependencies"
printf "\n--help shows its usage\n"

# checking arguments vality
for i in "$@"; do
	case $i in
	--h|--help)
		printf "Options:\n"
	 	printf " --no-qt                    Avoid installing qt\n"
		printf " --no-mysql                 Avoid installing MySQL\n"
	 	printf " --no-terralib              Avoid installing TerraLib\n"
	 	printf " --no-updatedb              Avoid updating the search database\n"
	 	printf " --with-r-dev               Install R and sp package\n"
	 	printf " --no-add-system-variables  Avoid apppending /etc/bash.bashrc\n"
	 	printf " --tldir:/my/own/path:      Default is in /usr/local\n"
		exit 0;;	
	--no-mysql|--no-qt|--no-terraview|--no-terralib|--no-updatedb|--tldir:*:|--no-add-system-variables) ;;
	*) printf "Invalid argument: $i\nTry --help for args information\n"
	   exit 1;
	esac
done

apt-get install subversion libdrm-dev libdime-dev

# mysql installation
if echo $@|grep -e --no-mysql > /dev/null
then
	printf "MySQL installation ignored\n"
else
	printf $LINE
	printf "Installing MySQL\n"
	printf $LINE

	apt-get install mysql-server-5.1 
	apt-get install libmysqlclient-dev
fi

# qt installation
if echo $@|grep -e --no-qt > /dev/null
then
	printf "Qt installation ignored\n"
else
	printf $LINE
	printf "Installing Qt\n"
	printf $LINE

	apt-get install libqt3-mt-dev
fi

# terraLib/terraView installation
if echo $@|grep -e --no-terralib > /dev/null
then
    printf "TerraLib installation ignored\n"
else
	printf $LINE
	printf "Installing TerraLib\n"
	printf $LINE

	# Choosing terraLib dir
	if echo $@|grep -e --tldir > /dev/null
	then
	    TERRALIB_DIR=$(echo $@|cut -d : -f 2)
	else
	    TERRALIB_DIR=/usr/local
	fi

	export TERRALIB_DIR
	cd $TERRALIB_DIR

	printf "Checking whether TerraLib already exists... \n"

	if test -e terralib-32; then
		if test -e terralib; then
			echo "Error: terralib and terralib-32 directories already exist. Delete them first and run this script again."
		else
			echo "Error: terralib-32 directory already exists. Delete it first and run this script again."
		fi
		exit 1
	fi

	if test -e terralib ; then
		echo "Error: terralib directory already exists. Delete it first and run this script again."
		exit 1
	fi

	mkdir terralib-32
	ln -s terralib-32 terralib
	cd terralib

	printf "Downloading terraLib\n"

	svn co https://svn.dpi.inpe.br/terralib/tags/v-3-6-0/src
	svn co https://svn.dpi.inpe.br/terralib/tags/v-3-6-0/dependencies/linux
	svn co https://svn.dpi.inpe.br/terralib/tags/v-3-6-0/terraView
	svn co https://svn.dpi.inpe.br/terralib/tags/v-3-6-0/build/qt

	mkdir dependencies
	mv linux dependencies

	mkdir build
	mv qt build

	printf "Compiling... (this operation may take some minutes)\n"

	cd build/qt
	LD_LIBRARY_PATH=$TERRALIB_DIR/terralib/Release/linux-g++:/usr/lib/ogdi/
	export LD_LIBRARY_PATH
	make
	cd ../../../
fi

# R installation
if echo $@|grep -e --with-r-dev > /dev/null
then
	printf $LINE
	printf "Installing r-dev\n"
	printf $LINE

	apt-get install r-base-dev

	printf $LINE
	printf "Installing sp package\n"
	printf $LINE

	printf "install.packages(\"sp\", repos=\"http://cran-r.c3sl.ufpr.br/\")" | R --no-save

else
	printf "MySQL installation ignored\n"
fi

# updating db
if echo $@|grep -e --no-updatedb > /dev/null
then
	printf "updatedb ignored\n"
else
	printf $LINE
	printf "Updating database... (this operation may take some minutes)\n"
	printf $LINE
	updatedb
fi
	
# adding variables to /etc/bash.bashrc
if echo $@|grep -e --no-add-system-variables > /dev/null
then
    printf "System variables ignored. Set them manually.\n"
else
    R_QUANTITY=$(locate libR.so |wc -l)
    MYSQL_QUANTITY=$(locate libmysqlclient.a |wc -l)
    LIBR_DIR_LOCATE=$(dirname `locate libR.so|head -n 1`)
	LIBMYSQL_DIR_LOCATE=$(dirname `locate libmysqlclient.a|head -n 1`)

    if [ -z "$LIBR_DIR_LOCATE" ]
    then
        printf "ERROR: libR.so was not found!\n"
        printf "Install it and run updatedb first.\n"
        printf "You may do this by running this script again using --with-r-dev\n"
        exit 1
    fi
    if [ -z "$LIBMYSQL_DIR_LOCATE" ]
    then
        printf "ERROR: libmysqlclient.a was not found!\n"
        printf "Install it and run updatedb first\n"
        exit 1
    fi

    LIBR_DIR=${LIBR_DIR_LOCATE}
	LIBMYSQL_DIR=${LIBMYSQL_DIR_LOCATE}

    if [ "$R_QUANTITY" -ne "1" ]
    then
        printf "WARNING: More than one libR.so were found\n"
        locate libR.so
        printf "\nOption choosed: $LIBR_DIR\n"
    fi

    if [ "$MYSQL_QUANTITY" -ne "1" ]
    then
        printf "WARNING: More than one libmysqlclient.a were found\n"
        locate libmysqlclient.a
        printf "\nOption choosed: $LIBMYSQL_DIR\n"
    fi

	# adding lines to a tmp file
    cat > $TEMP <<- EOF

		# lines added by install-aRT-dep.sh 
		TERRALIBDIR=$TERRALIB_DIR/terralib
		LIBRDIR=$LIBR_DIR
		LIBMYSQLCLIENTDIR=$LIBMYSQL_DIR
	EOF

    cat >> $TEMP <<- 'EOF'
		LD_LIBRARY_PATH=$LD_LIBRARY_PATH:\
		$TERRALIBDIR/Release/linux-g++:/usr/lib/ogdi/:\
		$LIBRDIR

		export TERRALIBDIR LIBMYSQLCLIENTDIR LIBRDIR LD_LIBRARY_PATH
	EOF

	cat $TEMP >> /etc/bash.bashrc

	printf "Do you want to edit the variables (/etc/bash.bashrc)? [y/n] "
	read OPTION

	if echo $OPTION|grep y > /dev/null
	then
		vim /etc/bash.bashrc
	fi
#	source /etc/bash.bashrc
fi

printf "Installation complete\n"
cd $CURRENT_DIR

