/****************************************************************************
** Form interface generated from reading ui file '../ui/graphic.ui'
**
** Created: Qui Dez 3 17:46:34 2009
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#ifndef GRAPHICWINDOW_H
#define GRAPHICWINDOW_H

#include <qvariant.h>
#include <qmainwindow.h>
#include <qwt_double_rect.h>
#include <TeQwtPlot.h>
#include <set>
#include <string>
#include <vector>
#include <TeDataTypes.h>
#include <TePDIHistogram.hpp>
#include <qwt_symbol.h>
#include <TeMatrix.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class TePlotWidget;
class TeCoord2D;
class GraphicParams;
class TeDatabase;
class TeAppTheme;
class TeQtGrid;
class TerraViewBase;
class QPopupMenu;
class TeQwtPlotCurve;
class TeQwtPlotZoomer;
class QToolButton;
class QwtPlotGrid;
class QwtPlotMarker;
using namespace std;
class Help;

class GraphicWindow : public QMainWindow
{
    Q_OBJECT

public:
    GraphicWindow( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );
    ~GraphicWindow();


    QColor pointingColor_;
    QColor defaultColor_;
    QFont verticalAxisFont_;
    QFont horizontalAxisFont_;
    QColor backgroundColor_;
    QPen minorLinePen_;
    QPen majorLinePen_;
    bool verticalMajorVisible_;
    bool verticalMinorVisible_;
    int gploted_;
    QwtSymbol dispersionSymbol_;
    QPen histogramPen_;
    QPen rasterHistogramPen_;
    QBrush rasterHistogramBrush_;
    QPen normalCurvePen_;
    QPen normalProbCurvePen_;
    bool horizontalMinorVisible_;
    bool horizontalMajorVisible_;
    QPen skaterPen_;
    QPen semivarCurvePen_;
    QPen semivarAdjustCurvePen_;

    virtual void setSkaterValues( vector<double> & setX, vector<double> & setY );
    virtual void setSemiVariogramValues( TeMatrix & mx, TeMatrix & mod );
    virtual void setAttributeTitle( const string & name );

public slots:
    float erf( float x );
    float gammln( float xx );
    float gammp( float a, float x );
    void gcf( float * gammcf, float a, float x, float * gln );
    void getHistogramValues();
    void getNormalValues();
    void getProbNormalValues();
    void getScatterValues();
    void getSelTabScatterValues();
    void gser( float * gamser, float a, float x, float * gln );
    void plotGraphic();
    void plotSelTable();
    void applyGraphic();
    void hide();
    void show();
    void getGraphicParamsSlot();
    double ymaxaxis();
    double xmaxaxis();
    double xminaxis();
    double yminaxis();
    int rxaxis();
    int ryaxis();
    void print();
    virtual void mousePressedSlot( int buttom, int state, QwtDoubleRect dr );
    virtual void zoomToggledSlot( bool b );
    virtual void previousZoomSlot();
    virtual void nextZoomSlot();
    virtual void previousZoomEnableSlot( bool b );
    virtual void nextZoomEnableSlot( bool b );
    virtual void graphicCursorActivatedSlot( bool b );
    virtual void putColorOnObjectSlot( TeAppTheme *, set<string> & );
    virtual void promoteToggledSlot( bool b );
    virtual void plotRasterHistogram( TePDIHistogram hist );
    virtual void configurationSlot();
    virtual void helpSlot();

signals:
    void mousePressedSignal(int);

protected:
    Help* help_;
    QwtPlotGrid* plotGrid_;
    string title_;
    string labelBottom_;
    string labelLeft_;
    bool zoomInit_;
    QwtPlotMarker* markerHH_;
    QToolButton *zoomToolButton_;
    double moranVy_[2];
    double moranVx_[2];
    double moranHy_[2];
    double moranHx_[2];
    bool moran_;
    double ymaxaxis_;
    int rxaxis_;
    int ryaxis_;
    double xmaxaxis_;
    double yminaxis_;
    double xminaxis_;
    TerraViewBase* mainWindow_;
    enum { Histogram, NormalProbability, Dispersion, RasterHistogram, Skater, Semivariogram };
    double EPS_;
    int ITMAX_;
    string yaxis_;
    string xaxis_;
    bool mleaved_;
    int mpressy_;
    int mpressx_;
    int ch_;
    int cw_;
    bool shiftPress_;
    double stdev_;
    double mean_;
    double* my_;
    double* mx_;
    double* ny_;
    double* nx_;
    double* y_;
    double* x_;
    vector<double> vmy_;
    vector<double> vmx_;
    vector<double> vny_;
    vector<double> vnx_;
    vector<double> vy_;
    vector<double> vx_;
    long double ymax_;
    long double ymin_;
    long double xmax_;
    long double xmin_;
    GraphicParams* graphicParams_;
    TeDatabase* db_;
    TeAppTheme* theme_;
    TeQtGrid* grid_;
    int graphicType_;
    int slices_;
    string attributeX_;
    string attributeY_;
    TeSelectedObjects selectedObjects_;
    TeQwtPlot *plot_;
    TeQwtPlotCurve *dataSelCurve_;
    TeQwtPlotZoomer *zoomer_;
    QToolButton *nextToolButton_;
    QToolButton *previousToolButton_;
    TeQwtPlotCurve* dataCurve_;
    QwtPlotMarker* markerLL_;
    QwtPlotMarker* markerLH_;
    QwtPlotMarker* markerHL_;
    QwtPlotMarker* marker_;
    QToolButton *promoteToolButton_;


protected slots:
    virtual void languageChange();

    virtual void init();
    virtual void closeEvent( QCloseEvent * );


};

#endif // GRAPHICWINDOW_H
