/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <qapplication.h>
#include <qmessagebox.h>

#include "TeAppTheme.h"
#include "terraViewBase.h"
#include "TeViewNode.h"
#include "TeRasterTransform.h"
#include "TeRasterParams.h"
#include "TeQtThemeItem.h"

#include <vector>

void RasterColorCompositionWindow::okPushButton_clicked()
{
	if (!theme_ || !raster_)
		reject();

	((TeTheme*)theme_->getTheme())->removeRasterVisual();
	TeRasterTransform* vis = new TeRasterTransform();

	short br = rLineEdit->text().toShort();
	short bg = gLineEdit->text().toShort();
	short bb = bLineEdit->text().toShort();
	if (!rLineEdit->text().isEmpty() && !gLineEdit->text().isEmpty() && !bLineEdit->text().isEmpty())
	{
		if (br == 0 && bg == 1  && bb == 2)
			vis->setTransfFunction(&TeRasterTransform::Band2Band);
		else
		{
			map<TeRasterTransform::TeRGBChannels,short> bmap;
			bmap[TeRasterTransform::TeREDCHANNEL] = br;
			bmap[TeRasterTransform::TeGREENCHANNEL] = bg;
			bmap[TeRasterTransform::TeBLUECHANNEL] = bb;
			vis->setRGBmap(bmap);
			vis->setTransfFunction(&TeRasterTransform::ExtractRGB);
		}
	}
	else
	{
		int n = 0;
		short srcB;
		short dstB;
		if (!rLineEdit->text().isEmpty())
		{
			vis->setBChannelMapping(br,TeRasterTransform::TeREDCHANNEL);
			srcB = br;
			dstB = 0;
			n++;
		}
		if (!gLineEdit->text().isEmpty())
		{
			vis->setBChannelMapping(bg,TeRasterTransform::TeGREENCHANNEL);
			n++;
			srcB = bg;
			dstB = 1;
		}
		if (!bLineEdit->text().isEmpty())
		{
			vis->setBChannelMapping(bb,TeRasterTransform::TeBLUECHANNEL);
			n++;
			srcB = bb;
			dstB = 2;
		}

		if (n==0)
		{
			QMessageBox::warning(this, tr("Warning"), tr("Select a band to be displayed!"));
				return;
		}

		if (n==1)
		{
			vis->clearRGBMap();
			vis->setSrcBand(srcB);
			vis->setDestBand(dstB);
			vis->setTransfFunction(&TeRasterTransform::ExtractBand);
		}
		else
			vis->setTransfFunction(&TeRasterTransform::ExtractBands);
	}
	((TeTheme*)theme_->getTheme())->rasterVisual(vis);
	accept();
	return;
}

void RasterColorCompositionWindow::init(TeQtThemeItem *themeItem)
{
	help_ = 0;

	mainWindow_ = (TerraViewBase*)qApp->mainWidget();
	theme_ = (TeAppTheme*)themeItem->getAppTheme();
	raster_ =  ((TeTheme*)theme_->getTheme())->layer()->raster();
	if (!theme_)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Select a theme!"));
		return;
	}
	unsigned int nb = raster_->params().nBands();
	bandListBox->clear();
	for (unsigned int i = 0; i<nb; ++i)
		bandListBox->insertItem(QString("%1").arg(i));
	
	TeRasterTransform* vis = ((TeTheme*)theme_->getTheme())->rasterVisual();
	if (!vis)
	{
		if (nb >=3)
		{
			rLineEdit->setText("0");
			gLineEdit->setText("1");
			bLineEdit->setText("2");
			bandListBox->setCurrentItem(0);
		}
		rRadioButton->setChecked(true);
		return;
	}
	if (vis->getTransfFunction() == TeRasterTransform::TeBand2Band)
	{
		rLineEdit->setText("0");
		gLineEdit->setText("1");
		bLineEdit->setText("2");
		return;
	}

	map<TeRasterTransform::TeRGBChannels,short>& RGBmap = vis->getRGBMap();
	if (vis->getTransfFunction() == TeRasterTransform::TeExtractRGB)
	{
		rLineEdit->setText(QString("%1").arg(RGBmap[TeRasterTransform::TeREDCHANNEL]));
		gLineEdit->setText(QString("%1").arg(RGBmap[TeRasterTransform::TeGREENCHANNEL]));
		bLineEdit->setText(QString("%1").arg(RGBmap[TeRasterTransform::TeBLUECHANNEL]));
		return;
	}

	map<TeRasterTransform::TeRGBChannels,short>::iterator it = RGBmap.begin();
	while (it != RGBmap.end())
	{
		if (it->first == TeRasterTransform::TeREDCHANNEL)
			rLineEdit->setText(QString("%1").arg(it->second));
		else if (it->first == TeRasterTransform::TeGREENCHANNEL)
			gLineEdit->setText(QString("%1").arg(it->second));
		else
			bLineEdit->setText(QString("%1").arg(it->second));
		++it;
	}
	rRadioButton->setChecked(true);
}

void RasterColorCompositionWindow::bandListBox_highlighted( int i )
{
    int brgb = rgbButtonGroup->selectedId();
    if (brgb ==0)
		rLineEdit->setText(bandListBox->text(i));
    else if (brgb == 1)
		gLineEdit->setText(bandListBox->text(i));
    else if (brgb == 2)
		bLineEdit->setText(bandListBox->text(i));	
}


void RasterColorCompositionWindow::rClearPushButton_clicked()
{
    rLineEdit->clear();
}


void RasterColorCompositionWindow::gClearPushButton_clicked()
{
    gLineEdit->clear();
}


void RasterColorCompositionWindow::bClearPushButton_clicked()
{
    bLineEdit->clear();
}


void RasterColorCompositionWindow::helpPushButton_clicked()
{
	if(help_)
		delete help_;

	help_ = new Help(this, "help", false);
	help_->init("rasterColorCompositionWindow.htm");
	if(help_->erro_ == false)
	{
		help_->show();
		help_->raise();
	}
	else
	{
		delete help_;
		help_ = 0;
	}
}
