TARGET = terraView
TEMPLATE = app
CONFIG += qt warn_on thread debug rtti exceptions
LANGUAGE = C++


SOURCES += ../main.cpp \
	../../src/terralib/utils/mtrand.cpp \
	../PluginsManager.cpp \
	../PluginParameters.cpp \
	../PluginsSignal.cpp \
	../PluginSupportFunctions.cpp \
	../terraView.cpp \
	../../src/terralib/functions/TeAddressLocator.cpp \
	../../src/terralib/stat/TeSemivarModelFactory.cpp \
	../../src/terralib/stat/TeMSVFactory.cpp \
	../TeApplicationUtils.cpp \
	../../src/terralib/functions/TeCellAlgorithms.cpp \
	../../src/terralib/utils/TeColorUtils.cpp \
	../../src/terralib/functions/TeCoordAlgorithms.cpp \
	../../src/terralib/utils/TeDatabaseUtils.cpp \
	../../src/terralib/drivers/qt/TeDecoderQtImage.cpp \
	../../src/terralib/drivers/shapelib/TeDriverSHPDBF.cpp \
	../../src/terralib/functions/TeExportMIF.cpp \
	../../src/terralib/functions/TeExportSPR.cpp \
	../../src/terralib/functions/TeGeoProcessingFunctions.cpp \
	../../src/terralib/drivers/qt/TeGUIUtils.cpp \
	../../src/terralib/functions/TeImportBNA.cpp \
	../../src/terralib/functions/TeImportCSV.cpp \
	../../src/terralib/functions/TeImportGeo.cpp \
	../../src/terralib/functions/TeImportMIF.cpp \
	../../src/terralib/functions/TeLayerFunctions.cpp \
	../../src/terralib/functions/TeMIFProjection.cpp \
	../../src/terralib/functions/TeExportCSV.cpp \ 
	../../src/terralib/drivers/Oracle/TeOracleSpatial.cpp \
	../../src/terralib/drivers/Oracle/TeOCIOracle.cpp \
	../../src/terralib/drivers/Oracle/TeOCIConnect.cpp \
	../../src/terralib/drivers/Oracle/TeOCICursor.cpp \
	../../src/terralib/drivers/Oracle/TeOCISDO.cpp \
	../../src/terralib/functions/TeThemeFunctions.cpp \
	../../src/terralib/drivers/MySQL/TeMySQL.cpp \
	../../src/terralib/drivers/PostgreSQL/TePGInterface.cpp \
	../../src/terralib/drivers/PostgreSQL/TePGUtils.cpp \
	../../src/terralib/drivers/PostgreSQL/TePostgreSQL.cpp \
	../../src/terralib/drivers/PostgreSQL/TePostGIS.cpp \
	../../src/terralib/drivers/qt/TeQtAnimaThread.cpp \
	../../src/terralib/drivers/qt/TeQtCanvas.cpp \
	../../src/terralib/drivers/qt/TeQtChartItem.cpp \
	../../src/terralib/drivers/qt/TeQtCheckListItem.cpp \
	../../src/terralib/drivers/qt/TeQtColorBar.cpp \
	../../src/terralib/drivers/qt/TeQtDatabaseItem.cpp \
	../../src/terralib/drivers/qt/TeQtDatabasesListView.cpp \
	../../src/terralib/drivers/qt/TeQtFrame.cpp \
	../../src/terralib/drivers/qt/TeQtGLWidget.cpp \
	../../src/terralib/drivers/qt/TeQtGrid.cpp \
	../../src/terralib/drivers/qt/TeQtGridSource.cpp \
	../../src/terralib/drivers/qt/TeQtLayerItem.cpp \
	../../src/terralib/drivers/qt/TeQtLegendItem.cpp \
	../../src/terralib/drivers/qt/TeQtLegendSource.cpp \
	../../src/terralib/drivers/qt/TeQtMethods.cpp \
	../../src/terralib/drivers/qt/TeQtShowMedia.cpp \
	../../src/terralib/drivers/qt/TeQtBigTable.cpp \
	../../src/terralib/drivers/qt/TeQtTable.cpp \
	../../src/terralib/drivers/qt/TeQtTerraStat.cpp \
	../../src/terralib/drivers/qt/TeQtTextEdit.cpp \
	../../src/terralib/drivers/qt/TeQtThemeItem.cpp \
	../../src/terralib/drivers/qt/TeQtViewItem.cpp \
	../../src/terralib/drivers/qt/TeQtViewsListView.cpp \
	../../src/terralib/drivers/qwt/TeQwtPlot.cpp \
	../../src/terralib/drivers/qwt/TeQwtPlotCurve.cpp \
	../../src/terralib/drivers/qwt/TeQwtPlotPicker.cpp \
	../../src/terralib/drivers/qwt/TeQwtPlotZoomer.cpp \
	../../src/terralib/functions/TeSimilarity.cpp \
	../../src/terralib/functions/TeSPRFile.cpp \
	../TeAppTheme.cpp \
	../../src/terralib/utils/TeUpdateDBVersion.cpp \
	../../src/terralib/drivers/qt/TeWaitCursor.cpp \
	../../src/terralib/kernel/TeRasterParams.cpp \
	../../src/terralib/kernel/TeDBConnectionsPool.cpp \
	../../src/terralib/kernel/TeExternalTheme.cpp

HEADERS	+= ../../src/terralib/utils/mtrand.h \
	../PluginsSignal.h \
	../../src/terralib/drivers/qt/resultVisual.h \
	../terraView.h \
	../../src/terralib/drivers/qt/TeAddressNotifyFunctorWindow.h \
	../../src/terralib/functions/TeAddressLocator.h \
	../../src/terralib/stat/TeSemivarModelFactory.h \
	../../src/terralib/stat/TeMSVFactory.h \
	../TeApplicationUtils.h \
	../../src/terralib/functions/TeCellAlgorithms.h \
	../../src/terralib/utils/TeColorUtils.h \
	../../src/terralib/functions/TeCoordAlgorithms.h \
	../../src/terralib/utils/TeDatabaseUtils.h \
	../../src/terralib/drivers/qt/TeDecoderQtImage.h \
	../../src/terralib/functions/TeDriverCSV.h \
	../../src/terralib/drivers/shapelib/TeDriverSHPDBF.h \
	../../src/terralib/functions/TeGeoProcessingFunctions.h \
	../../src/terralib/functions/TeImportExport.h \
	../../src/terralib/functions/TeLayerFunctions.h \
	../../src/terralib/functions/TeMIFProjection.h \
	../../src/terralib/drivers/MySQL/TeMySQL.h \
	../../src/terralib/drivers/Oracle/ociap.h \
	../../src/terralib/drivers/Oracle/TeOracleSpatial.h \
	../../src/terralib/drivers/Oracle/TeOCIOracle.h \
	../../src/terralib/drivers/Oracle/TeOCIConnect.h \
	../../src/terralib/drivers/Oracle/TeOCICursor.h \
	../../src/terralib/drivers/Oracle/TeOCISDO.h \
	../TePlotTheme.h \
	../PluginInfo.h \
	../PluginParameters.h \
	../PluginsManager.h \
	../PluginSupportFunctions.h \
	../../src/terralib/drivers/PostgreSQL/TePGInterface.h \
	../../src/terralib/drivers/PostgreSQL/TePGUtils.h \
	../../src/terralib/drivers/PostgreSQL/TePostgreSQL.h \
	../../src/terralib/drivers/PostgreSQL/TePostGIS.h \
	../../src/terralib/drivers/qt/TeQtAnimaThread.h \
	../../src/terralib/drivers/qt/TeQtCanvas.h \
	../../src/terralib/drivers/qt/TeQtChartItem.h \
	../../src/terralib/drivers/qt/TeQtCheckListItem.h \
	../../src/terralib/drivers/qt/TeQtColorBar.h \
	../../src/terralib/drivers/qt/TeQtDataSource.h \
	../../src/terralib/drivers/qt/TeQtDatabaseItem.h \
	../../src/terralib/drivers/qt/TeQtDatabasesListView.h \
	../../src/terralib/drivers/qt/TeQtFrame.h \
	../../src/terralib/drivers/qt/TeQtGLWidget.h \
	../../src/terralib/drivers/qt/TeQtGrid.h \
	../../src/terralib/drivers/qt/TeQtGridSource.h \
	../../src/terralib/drivers/qt/TeQtLayerItem.h \
	../../src/terralib/drivers/qt/TeQtLegendItem.h \
	../../src/terralib/drivers/qt/TeQtLegendSource.h \
	../../src/terralib/drivers/qt/TeQtMethods.h \
	../../src/terralib/drivers/qt/TeQtProgress.h \
	../../src/terralib/drivers/qt/TeQtShowMedia.h \
	../../src/terralib/drivers/qt/TeQtBigTable.h \
	../../src/terralib/drivers/qt/TeQtTable.h \
	../../src/terralib/drivers/qt/TeQtTerraStat.h \
	../../src/terralib/drivers/qt/TeQtTextEdit.h \
	../../src/terralib/drivers/qt/TeQtThemeItem.h \
	../../src/terralib/drivers/qt/TeQtViewItem.h \
	../../src/terralib/drivers/qt/TeQtViewsListView.h \
	../../src/terralib/drivers/qwt/TeQwtPlot.h \
	../../src/terralib/drivers/qwt/TeQwtPlotCurve.h \
	../../src/terralib/drivers/qwt/TeQwtPlotPicker.h \
	../../src/terralib/drivers/qwt/TeQwtPlotZoomer.h \
	../../src/terralib/functions/TeSPRFile.h \
	../TeAppTheme.h \
	../../src/terralib/utils/TeUpdateDBVersion.h \
	../../src/terralib/drivers/qt/TeWaitCursor.h \
	../../src/zlib/zlib.h
	
	
TRANSLATIONS =  \
	../terraView_pt.ts \
	../terraView_sp.ts
 

INCLUDEPATH	+= . \
	.. \
	../../src/qwt/include \
	../../src/terralib/drivers/qwt \
	../../src/terralib/drivers/shapelib \
	../../src/terralib/kernel \
	../../src/terralib/utils \
	../../src/terralib/functions \
	../../src/terralib/stat \
	../../src/shapelib \
	../../src/zlib \
	../../src/libspl \
	../ui \
	../../src/terralib/drivers/qt \
	../../src/terralib/drivers/MySQL \
	../../src/terralib/drivers/MySQL/include \
	../../src/terralib/drivers/Oracle \
	../../src/terralib/drivers/Oracle/OCI/include \
	../../src/terralib/drivers/PostgreSQL \
	../../src/terralib/drivers/PostgreSQL/includepg \
	../../src/terralib/image_processing

	
win32 {
	DESTDIR = ../../Debug
	UI_DIR  = ../../ui/terraView
	MOC_DIR = ../../moc/terraView
	OBJECTS_DIR = ../../Debug/terraView
	QMAKE_CXXFLAGS_MT_DBG +=  -MDd -Od -Fd..\..\Debug\terraView
	QMAKE_LFLAGS_DEBUG += /NODEFAULTLIB:msvcrt.lib /PDB:..\..\Debug\terraView\terraView.pdb
	
	SOURCES	+= \
		qmake_image_collection.cpp \
		../../terralibw/ado/TeAdoDB.cpp \
		../../terralibw/ado/TeAdoOracle.cpp \
		../../terralibw/ado/TeAdoSqlServer.cpp

	HEADERS	+= \
		../../terralibw/ado/TeAdoDB.h \
		../../terralibw/ado/TeAdoOracle.h \
		../../terralibw/ado/TeAdoSqlServer.h
		
	INCLUDEPATH +=	\
		../../terralibw/ado \
		$(QTDIR)/include
		
	LIBS = \
		$(QTDIR)/lib/qt.lib \
		../../Debug/qwt/qwt.lib \
		../../Debug/shapelib/shapelib.lib \
		../../Debug/stat/stat.lib \
		../../Debug/terralib/terralib.lib \
		../../Debug/tiff/tiff.lib \
		../../Debug/libjpeg/libjpeg.lib \
		../../Debug/terralibpdi/terralibpdi.lib \
		../../terralibw/Oracle/Oci/Oci.lib \
		../../terralibw/MySQL/libMySQL.lib \
		../../terralibw/PostgreSQL/libpq.lib \
		../../terralibw/DSDK/Debug/lti_dsdk_dll.lib \
		../../terralibw/DSDK/3rd-party/lib/Debug/gdalogr.lib \
		opengl32.lib \
		glu32.lib
		
	QMAKE_POST_LINK +=	copy *.dll ..\..\Debug
}

unix {
	UI_DIR = ui
	MOC_DIR = .moc
	OBJECTS_DIR = .obj
		
	INCLUDEPATH +=	../../src/terralib/drivers

	LIBS += \
		-L../../terralibx/lib \
		-L/usr/lib/mysql \
		-L/usr/local/mysql/lib \
		-L../../terralibx/DSDK \
		-L../../terralibx/DSDK/3rd-party/lib \
		-lqwt -lshapelib -lstat -lterralib -ltiff -ljpeg \
		-lmysqlclient -lspl -lpq -lclntsh -lnnz10 -lcrypt \
		-lltidsdk -lgdal -lterralibpdi -lGL -lGLU
}

	
FORMS = ../ui/addColumn.ui \
	../ui/addressChoiceWindow.ui \
	../ui/addressLocatorWindow.ui \
	../ui/addressNameSeparator.ui \
	../ui/addTheme.ui \
	../ui/addView.ui \
	../ui/anaesp.ui \
	../ui/animation.ui \
	../ui/bayesWindow.ui \
	../ui/changeColData.ui \
	../ui/changeColumnName.ui \
	../ui/changeColumnType.ui \
	../ui/changeMinMax.ui \
	../ui/connectView.ui \
	../ui/contrast.ui \
	../ui/createBuffersWindow.ui \
	../ui/countComputing.ui \
	../ui/createCells.ui \
	../ui/createLayerFromTheme.ui \
	../ui/createProxMatrix.ui \
	../ui/createTable.ui \
	../ui/createTextRepresentation.ui \
	../ui/createThemeFromTheme.ui \
	../ui/database.ui \
	../ui/databaseProp.ui \
	../ui/display.ui \
	../ui/displaySize.ui \
	../ui/exportWindow.ui \
	../ui/generateSamplePoints.ui \
	../ui/geoOpAdd.ui \
	../ui/geoOpAggregation.ui \
	../ui/geoOpAssignDataLocationCollect.ui \
	../ui/geoOpAssignDataLocationDistribute.ui \
	../ui/geoOpOverlayDifference.ui \
	../ui/geoOpOverlayIntersection.ui \
	../ui/geoOpOverlayUnion.ui \
	../ui/geographicalGrid.ui \
	../ui/graphic.ui \
	../ui/graphic3DWindow.ui \
	../ui/graphicConfigurationWindow.ui \
	../ui/graphicParams.ui \
	../ui/help.ui \
	../ui/histogramBuildForm.ui \
	../ui/import.ui \
	../ui/importRasterSimple.ui \
	../ui/importTable.ui \
	../ui/importTbl.ui \
	../ui/importTablePoints.ui \
	../ui/importTblPoints.ui \
	../ui/insertPoint.ui \
	../ui/insertText.ui \
	../ui/insertSymbol.ui \
	../ui/kernelRatioWindow.ui \
	../ui/kernelWindow.ui \
	../ui/layerProp.ui \
	../ui/lbsDefinition.ui \
	../ui/legendWindow.ui \
	../ui/linkExtTable.ui \
	../ui/localBayesWindow.ui \
	../ui/mediaDescription.ui \
	../ui/pieBarChart.ui \
	../ui/printFileResolution.ui \
	../ui/projection.ui \
	../ui/query.ui \
	../ui/rasterColorCompositionWindow.ui \
	../ui/rasterImportWizard.ui \
	../ui/rasterSlicingWindow.ui \
	../ui/rasterTransparency.ui \
	../ui/removeTable.ui \
	../ui/saveAndLoadColorBarWindow.ui \
	../ui/saveAsTable.ui \
	../ui/saveRaster.ui \
	../ui/saveTableAsTxt.ui \
	../ui/saveThemeToFileWindow.ui \
	../ui/selThemeTables.ui \
	../ui/selectProxMatrix.ui \
	../ui/selectTextRepresentation.ui \
	../ui/semivar.ui \
	../ui/skaterWindow.ui \
	../ui/spatializationWindow.ui \
	../ui/spatialQuery.ui \
	../ui/statistic.ui \
	../ui/tableProp.ui \
	../ui/terraViewBase.ui \
	../ui/textRep.ui \
	../ui/themeProp.ui \
	../ui/themeVis.ui \
	../ui/urlWindow.ui \
	../ui/viewProp.ui \
	../ui/visual.ui

IMAGES	= ../ui/images/addressDictionary.png \
	../ui/images/addressLayer.png \
	../ui/images/addressReferenceLayer.png \
	../ui/images/addressTable.png \
	../ui/images/and.bmp \
	../ui/images/area.bmp \
	../ui/images/buffer.bmp \
	../ui/images/bufferNoUnion.bmp \
	../ui/images/bufferUnion.bmp \
	../ui/images/clearColor.bmp \
	../ui/images/closeDB.bmp \
	../ui/images/containLin.bmp \
	../ui/images/containLinPol.bmp \
	../ui/images/containLinPon.bmp \
	../ui/images/containPol.bmp \
	../ui/images/convexHull.bmp \
	../ui/images/coverByPol.bmp \
	../ui/images/coverLinPol.bmp \
	../ui/images/coverPol.bmp \
	../ui/images/crossLin.bmp \
	../ui/images/crossLinPol.bmp \
	../ui/images/database.bmp \
	../ui/images/databasesTree.bmp \
	../ui/images/disjointLin.bmp \
	../ui/images/disjointLinPol.bmp \
	../ui/images/disjointLinPon.bmp \
	../ui/images/disjointPol.bmp \
	../ui/images/disjointPonPol.bmp \
	../ui/images/display.bmp \
	../ui/images/distance.bmp \
	../ui/images/distMeter.bmp \
	../ui/images/draw.bmp \
	../ui/images/edit.xpm \
	../ui/images/equalLin.bmp \
	../ui/images/equalPol.bmp \
	../ui/images/graphic.bmp \
	../ui/images/graphicConfig.bmp \
	../ui/images/graphicCursor.bmp \
	../ui/images/grid.bmp \
	../ui/images/help.bmp \
	../ui/images/import.bmp \
	../ui/images/infoCursor.bmp \
	../ui/images/infolayer.bmp \
	../ui/images/insideAndOutside.png \
	../ui/images/invertColor1.bmp \
	../ui/images/invertSelection.bmp \
	../ui/images/isContainLin.bmp \
	../ui/images/isContainLinPol.bmp \
	../ui/images/isContainPol.bmp \
	../ui/images/isContainPonPol.bmp \
	../ui/images/left.bmp \
	../ui/images/length.bmp \
	../ui/images/minus.bmp \
	../ui/images/nearstNeigh.bmp \
	../ui/images/nextDisplay.bmp \
	../ui/images/nonEdit.xpm \
	../ui/images/onlyInside.png \
	../ui/images/onlyOutside.png \
	../ui/images/openfile.bmp \
	../ui/images/or.bmp \
	../ui/images/overlapLin.bmp \
	../ui/images/overlapPol.bmp \
	../ui/images/panCursor.bmp \
	../ui/images/pointer.bmp \
	../ui/images/previousDisplay.bmp \
	../ui/images/print.bmp \
	../ui/images/promote.bmp \
	../ui/images/reset.bmp \
	../ui/images/right.bmp \
	../ui/images/table.bmp \
	../ui/images/terralib.bmp \
	../ui/images/theme.bmp \
	../ui/images/tileWindows.bmp \
	../ui/images/touchLin.bmp \
	../ui/images/touchLinPol.bmp \
	../ui/images/touchLinPon.bmp \
	../ui/images/touchPol.bmp \
	../ui/images/touchPonPol.bmp \
	../ui/images/unselect.bmp \
	../ui/images/view.bmp \
	../ui/images/viewsTree.bmp \
	../ui/images/xor.bmp \
	../ui/images/zoomCursor.bmp \
	../ui/images/zoomIn.bmp \
	../ui/images/zoomOut.bmp
