
LIBSPLPATH = ../../src/libspl

win32 {
  error( "To build LibSPL for Windows use the Visual Studio project file." )
}

CONFIG = dll

TEMPLATE = lib

TARGET  = spl

INCLUDEPATH = $$LIBSPLPATH $$LIBSPLPATH/include

# VPATH = $$LIBSPLPATH/include $$LIBSPLPATH/source

MOC_DIR = temp
UI_DIR = temp
  
isEmpty(TE_PROJECT_TYPE) {
  TE_PROJECT_TYPE=RELEASE
}

contains(TE_PROJECT_TYPE , DEBUG) {
  CONFIG += debug
}

contains(TE_PROJECT_TYPE , RELEASE) {
  CONFIG += release
}

unix {
  release {
    DEFINES += NDEBUG
    OBJECTS_DIR = ../Release/.obj/libspl
    DESTDIR = ../Release
  }

  debug {
    DEFINES += _DEBUG
    OBJECTS_DIR = ../Debug/.obj/libspl
    DESTDIR = ../Debug
  }
}

HEADERS = \
  $$LIBSPLPATH/spl.h \
  $$LIBSPLPATH/include/spl_pluginargs.h \
  $$LIBSPLPATH/include/spl_pluginserver_linux.h \
  $$LIBSPLPATH/include/spl_threadlock.h \
  $$LIBSPLPATH/include/spl_mutex.h \
  $$LIBSPLPATH/include/spl_plugininfo.h \
  $$LIBSPLPATH/include/spl_pluginserver_solaris.h \
  $$LIBSPLPATH/include/spl_typedefs.h \
  $$LIBSPLPATH/include/spl_platform.h \
  $$LIBSPLPATH/include/spl_pluginserver.h \
  
SOURCES = \
  $$LIBSPLPATH/source/spl_pluginserver.cpp \
  $$LIBSPLPATH/source/spl_pluginserver_linux.cpp \
  $$LIBSPLPATH/source/spl_pluginargs.cpp \
  $$LIBSPLPATH/source/spl_mutex.cpp \
  $$LIBSPLPATH/source/spl_threadlock.cpp \
  $$LIBSPLPATH/source/spl_plugininfo.cpp