/****************************************************************************
** Form interface generated from reading ui file '../ui/display.ui'
**
** Created: Ter Dez 15 00:36:14 2009
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#ifndef DISPLAYWINDOW_H
#define DISPLAYWINDOW_H

#include <qvariant.h>
#include <qmainwindow.h>
#include <TeCoord2D.h>
#include <vector>
#include <TeDataTypes.h>
#include <TeQtTextEdit.h>
#include <qpointarray.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class QCanvas;
class TerraViewBase;
class TeQtCanvas;
class TeCoord2D;
struct TeBox;
using namespace std;
class QPopupMenu;
class QPixmap;
class TeAppTheme;

class DisplayWindow : public QMainWindow
{
    Q_OBJECT

public:
    DisplayWindow( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );
    ~DisplayWindow();


    TeQtCanvas * getCanvas();
    virtual bool plotXor( bool mode );
    virtual void plotGraphicScale();
    virtual void plotGeographicalGrid();
    virtual void updateTextEdit();
    virtual void plotData();
    virtual bool legendFromKernel( TeAppTheme * theme, vector<string> & kHeader );
    virtual QRect getRectLegendOnCanvas( TeAppTheme * theme, vector<string> & s );
    virtual void plotLegendOnCanvas( TeAppTheme * theme );
    virtual void resetEditions();
    virtual QPointArray getCircle( QPoint pa, QPoint pb );
    virtual QPointArray getElipse( QPoint pc, int rx, int ry );
    virtual vector<QPointArray> rotateXorPoints();
    virtual QPixmap * getContrastPixmap();
    virtual void setContrastPixmap( QPixmap * p );
    virtual void resetConnectedPixmap();
    virtual TeBox getPieBarBox(TeAppTheme*);
    void setScaleGraphicUnit(int n);
    bool getGUScaleSetting();
    int getSGUnit();
    virtual void rasterDataToStatusBar(TeLayer* layer, TeCoord2D pdw);
    virtual void createGraphicScaleTable();

public slots:
    virtual void closeEvent( QCloseEvent * );
    virtual void mouseMovedOnCanvas( TeCoord2D & pt, int state, QPoint & m );
    virtual void keyPressedOnCanvas( QKeyEvent * e );
    virtual void keyReleasedOnCanvas( QKeyEvent * e );
    virtual void graphicScaleVisualSlot( int view_id );
    virtual void plotConnectedView();
    virtual void plotData( TeBox box, bool docopy );
    virtual void plotData( TeAppTheme * theme, set<string> & drawSet );
    virtual void spatialOperationButtonGroup_clicked( int i );
    virtual void popupCanvasSlot( QMouseEvent * m );
    virtual void ownVisualSlot();
    virtual void removeOwnVisualSlot();
    virtual void removeAllOwnVisualsSlot();
    void popupGraphicScaleVisualSlot();
    virtual void showGraphicScaleSlot();
    virtual void showGeographicalCoordinatesSlot();
    virtual void popupGeographicalCoordinatesVisualSlot();
    virtual void changeLegendVisualSlot();
    virtual void setSquareCursorTypeSlot();
    virtual void setCircleCursorTypeSlot();
    virtual void insertTextSlot();
    virtual void editTextSlot();
    virtual void textEditVisualSlot();
    virtual void popupDrawSelectedOnCenterSlot();
    virtual void setDefaultVisual();
    virtual void setPointingVisual();
    virtual void setQueryVisual();
    virtual void setPointingQueryVisual();
    virtual void changeZoomFactorSlot( int zoomFactor );
    virtual void popupInsertPointSlot();
    virtual void popupDeletePointedObjectsSlot();
    virtual void popupAnimationSlot();
    virtual void restoreConnectedRect( QRect & rect );
    virtual void paintEventSlot();
    virtual void popupInsertSymbolSlot();
    void removeRasterContrastSlot();
    virtual void plotOnPrinter( QString fileName );
    virtual void displaySizeSlot();
    virtual void setGraphicScaleUnit_DecimalDegreesSlot();
    virtual void setGraphicScaleUnit_KilometersSlot();
    virtual void setGraphicScaleUnit_MetersSlot();
    virtual void setGraphicScaleUnit_FeetsSlot();

signals:
    void distanceMeterSignal(TeCoord2D, TeCoord2D);

protected:
    QPoint mGraphicScale_;
    double graphicScaleOffsetY_;
    double graphicScaleOffsetX_;
    QPoint pGraphicScale_;
    bool graphicScaleVisible_;
    bool symbolFixedSize_;
    QColor symbolColor_;
    int symbolSize_;
    QString symbolFamily_;
    QPixmap *contrastPixmap_;
    bool drawSetOnCenter_;
    TeCoord2D textInsertion_;
    bool displaySelection_;
    QPopupMenu *popupCanvas_;
    TeSpatialRelation spatialOperation_;
    string object_id_;
    TeCoord2D pLeg_;
    TeBox pieBarBoxEdit_;
    vector<QPointArray> xorPointArrayVec_;
    bool graphCursorOn_;
    bool editOn_;
    TeCoord2D panStart_;
    TerraViewBase* mainWindow_;
    TeQtCanvas *canvas_;
    TeQtMultiTextEdit mtEdit_;
    bool xorOn_;
    TeQtMultiTextEdit xorMtEdit_;
    QPoint cGraphCursor_;
    int wGraphCursor_;
    int hGraphCursor_;
    string tipId_;
    QRect rectLegendOnCanvas_;
    QRect textRectSelected_;
    string pointedObjId_;
    QPopupMenu* popupOwnVisual_;
    QPopupMenu* popupSpatialCursorType_;
    QPoint distancePoint_;
    int circleRadius_;
    double spatialCursorAngle_;
    int mtEditInd_;
    QPopupMenu* popupZoom_;
    double zoomFactor_;
    TeBox pointBoxEdit_;
    TeCoord2D rightButtonPressed_;
    QPixmap* connectedPixmap_;
    QRect connectedRect_;
    QPopupMenu* popupGraphicScaleUnit_;
    bool isSGUnitSet_;
    int SGUnit_;
    double unitConv_;
    string unit_;

    virtual QRect plotLegendKernel( QPoint & pIni, vector<string> & s );

    QGridLayout* DisplayWindowLayout;

protected slots:
    virtual void languageChange();

    virtual void init();
    virtual void resizeEvent( QResizeEvent * );
    virtual void mousePressedOnCanvas( TeCoord2D & pt, int state, QPoint & m );
    virtual void mouseRightButtonPressedOnCanvas( TeCoord2D & pt, int, QPoint & );
    virtual void mouseReleasedOnCanvas( TeCoord2D & pt, int state, QPoint & m );
    virtual void mouseDoublePressedOnCanvas( TeCoord2D & pt, int state, QPoint & );
    virtual void mouseLeaveCanvas();


};

#endif // DISPLAYWINDOW_H
